/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.literalskyblock.integration;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.renderer.LevelRenderer;
import org.slf4j.Logger;

public class IrisCompat {
    private static final Logger LOGGER;
    private static final Field PIPELINE;

    public static void preRender(LevelRenderer renderer) {
        if (PIPELINE == null) {
            return;
        }
        try {
            WorldRenderingPipeline pipeline = Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
            PIPELINE.set(renderer, pipeline);
            pipeline.beginLevelRendering();
            pipeline.setPhase(WorldRenderingPhase.NONE);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Exception in preRender", (Throwable)e);
        }
    }

    public static void postRender(LevelRenderer renderer) {
        if (PIPELINE == null) {
            return;
        }
        try {
            WorldRenderingPipeline pipeline = (WorldRenderingPipeline)PIPELINE.get(renderer);
            pipeline.finalizeLevelRendering();
            PIPELINE.set(renderer, null);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Exception in postRender", (Throwable)e);
        }
    }

    static {
        Field pipeline;
        LOGGER = LogUtils.getLogger();
        try {
            pipeline = LevelRenderer.class.getDeclaredField("pipeline");
            pipeline.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            pipeline = null;
            LOGGER.error("Failed to get Iris pipeline field", (Throwable)e);
        }
        PIPELINE = pipeline;
    }
}

